define([
    'Layout',
    'backbone',
    'App',
    'modules/notifications/notifications-module',
    'modules/appointments/appointments-layout-view',
],
function(Layout, Backbone, app, notificationsModule, AppointmentsLayoutView) {
    'use strict';

    describe('Appointments Layout View', function() {
        var view;
        var $view;
        var layout = new Layout();
        var gas;
        var appointmentsModule;

        var IsEligibleForCC;
        var ccIsDisabled;
        var spy;
        var ccEligFeatureEnabled;
        var ccRequestingIsDisabled;
        layout.render();

        beforeEach(function() {
            spyOn(notificationsModule.notifications, 'fetch').and.callFake(function() {
                var resolved = new $.Deferred();
                resolved.resolve();
                return resolved;
            });
            spyOn(Backbone.history, 'navigate');
            spyOn(AppointmentsLayoutView.prototype, 'showBookedAppointmentsView');
            spyOn(AppointmentsLayoutView.prototype, 'showRequestedAppointmentsView');
            spyOn(AppointmentsLayoutView.prototype, 'showNotificationsButtonView');
            view = new AppointmentsLayoutView({
                googleAnalyticsProvider: { getInstance: function() {
                    gas = jasmine.createSpyObj('gas', ['gas']);
                    return gas;
                }},
                appointmentsModuleProvider: { getInstance: function() {
                    appointmentsModule = jasmine.createSpyObj('appointmentsModule', ['appointments', 'requests']);
                    appointmentsModule.requests = {
                        isReady: new $.Deferred(),
                        fetch: function() {
                            return;
                        },
                    };

                    appointmentsModule.appointments = {
                        isReady: function() {
                            view.showRequestedAppointmentsView();
                        },
                        fetchAppointmentData: function() {
                            return;
                        },
                    };

                    return appointmentsModule;
                }},
            });
            spyOn(app, 'isCcEligFeatureEnabled').and.callFake(function() {
                return true;
            });
            spy = jasmine.createSpy(view, 'routeToNewAppointmentRequest').and.callFake(function() {
                ccRequestingIsDisabled = ccEligFeatureEnabled === true && IsEligibleForCC === false;
                if (ccIsDisabled === true) {
                    Backbone.history.navigate('new-va-appointment-request', {trigger: true});
                } else if (ccRequestingIsDisabled === true) {
                    Backbone.history.navigate('new-va-appointment-request', {trigger: true});
                } else {
                    Backbone.history.navigate('new-appointment-request', {trigger: true});
                }
            });
            view = new AppointmentsLayoutView({
                googleAnalyticsProvider: {
                    getInstance: function() {
                        gas = jasmine.createSpyObj('gas', ['gas']);
                        return gas;
                    },
                },
                appointmentsModuleProvider: { getInstance: function() {
                    appointmentsModule = jasmine.createSpyObj('appointmentsModule', ['appointments', 'requests']);
                    appointmentsModule.requests = {
                        isReady: new $.Deferred(),
                        fetch: function() {
                            return;
                        },
                    };

                    appointmentsModule.appointments = {
                        isReady: function() {
                            view.showRequestedAppointmentsView();
                        },
                        fetchAppointmentData: function() {
                            return;
                        },
                    };

                    return appointmentsModule;
                }},
            });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        afterEach(function() {
            layout.getRegion('content').empty();
        });

        it('has a primary content header', function() {
            expect($view.find('.primary-header').find('h2')
                .text()).toEqual('Appointments/Requests');
        });

        it('has regions to show notifications button and booked and requested appointments', function() {
            expect($view.has(view.regions.notificationsRegion).length).toEqual(1);
            expect($view.has(view.regions.bookedAppointmentsRegion).length).toEqual(1);
            expect($view.has(view.regions.requestedAppointmentsRegion).length).toEqual(1);
        });

        it('shows notifications button and booked and requested appointments', function () {
            expect(view.showNotificationsButtonView).toHaveBeenCalled();
            // expect(view.showBookedAppointmentsView).toHaveBeenCalled();
            expect(view.showRequestedAppointmentsView).toHaveBeenCalled();
        });

        it('has region for aria live message', function() {
            expect($view.has(view.regions.ariaLiveRegion).length).toEqual(1);
        });

        it('should call Google Analytics when the refresh button is pressed', function() {
            view.refreshAppointmentViews();
            expect(gas.gas).toHaveBeenCalledWith('send', 'event', 'veteran-appointment', 'refresh-appointments-clicked');
        });

        describe('when routing between va workflow and cc workflow', function() {
            it('will go to va workflow when cc eligibity is not enabled and cc workflow is diabled', function() {
                ccIsDisabled = true;
                ccEligFeatureEnabled = false;
                spy();
                expect(Backbone.history.navigate).toHaveBeenCalledWith('new-va-appointment-request', {trigger: true});
            });

            it('will go to va workflow when cc eligibity is enabled and and user is not eligible for cc', function() {
                ccIsDisabled = true;
                ccEligFeatureEnabled = true;
                IsEligibleForCC = false;
                spy();
                expect(Backbone.history.navigate).toHaveBeenCalledWith('new-va-appointment-request', {trigger: true});
            });

            it('will go to cc workflow when cc eligibity is not enabled and cc workflow is not diabled', function() {
                ccIsDisabled = false;
                ccEligFeatureEnabled = false;
                spy();
                expect(Backbone.history.navigate).toHaveBeenCalledWith('new-appointment-request', {trigger: true});
            });

            it('will go to ccworkflow when cc eligibity is not enabled and cc workflow is not diabled', function() {
                ccIsDisabled = false;
                ccEligFeatureEnabled = false;
                spy();
                expect(Backbone.history.navigate).toHaveBeenCalledWith('new-appointment-request', {trigger: true});
            });

            it('will go to cc workflow when cc eligibity is enabled and user is eligible for cc route to cc workflow', function() {
                ccIsDisabled = false;
                ccEligFeatureEnabled = true;
                IsEligibleForCC = true;
                spy();
                expect(Backbone.history.navigate).toHaveBeenCalledWith('new-appointment-request', {trigger: true});
            });
        });
    });
});
